TITLE   'P-N Junction Diode, Forward Current' 	        { exa214f.pde }
SELECT     errlim=1e-6     stages=10
COORDINATES						{ Professional Version }
   cartesian1
VARIABLES   Ex
DEFINITIONS
   Lx=2e-5     temp=300
   q=1.60e-19     kb=1.38e-23     eps0=8.85e-12     eps=12*eps0
   ni=1.5e16     mue=0.13     muh=0.05     ne0     nh0
   E_res   					{ Field due to resistive voltage drop }
   nh1=1000*ni     ne1=ni^2/nh1     ne2=800*ni     nh2=ni^2/ne2
   De=mue*kb*temp/q     Dh=muh*kb*temp/q
   rho=dx( eps*Ex)			{ Volume charge density }
   ne=-0.5*( rho/q- ne0+ nh0)+ sqrt[ 0.25*( rho/q- ne0+ nh0)^2+ ni^2]
   nh=-0.5*( ne0- nh0- rho/q)+ sqrt[ 0.25*( ne0- nh0- rho/q)^2+ ni^2]
   Je=q*mue*ne*Ex     Jh=q*muh*nh*Ex  	{ Drift current density }
   Jde=q*De*dx( ne)     Jdh= -q*Dh*dx(nh)	{ Diffusion current d. }
   E2=(stage-1)*1e4     J0=(q*ne2*mue+q*nh2*muh)*E2
   E1=J0/(q*ne1*mue+q*nh1*muh)
   U_res=E1*Lx+ E2*Lx	{ Approximation to resistive voltage drop }
   Ex_reduced=Ex- E_res	{ Field with resistive part subtracted }
EQUATIONS
   q*mue*ne*Ex+ q* De*dx( ne)+ q*muh*nh*Ex- q*Dh*dx(nh)=J0
BOUNDARIES
region 'domain'  nh0=nh1   ne0=ne1      		{ Mostly holes }
   E_res=E1				{ Resistive field in the hole region }
   start (-Lx) point value(Ex)=E1
   line to (Lx) point value(Ex)=E2
region 'n_conductor'  nh0=nh2  ne0=ne2   E_res=E2
   start (0) line to (Lx)
PLOTS
   elevation( Ex) from (-Lx) to (Lx)
   elevation(Ex_reduced) from (-Lx) to (Lx)
   elevation( rho, q*ne0, -q*nh0) from (-Lx) to (Lx)
   elevation( nh0, ne0) from (-Lx) to (Lx)
   elevation( nh, ne) from (-Lx) to (Lx)
   elevation( Jh, Je) from (-Lx) to (Lx)
   elevation( Jdh, Jde) from (-Lx) to (Lx)	
   elevation( nh*ne) from (-Lx) to (Lx)	{ Verification of equilibrium }
      report( J0)  report( U_res)
END

